/*****************************************************************************
*  LPC4357 SCT demo
*  Use SCT to generate a center aligned PWM signal
*****************************************************************************/
#include "nxp_lpc43xx.h"

void SCT_Init(void)
{
    LPC_SCT->CONFIG        |= (1 << 17);                   // two 16-bit timers, auto limit
    LPC_SCT->CTRL_L        |= (1 << 4) | ((6-1) << 5);     // Bidir mode, prescaler = 6, SCT clock = 2 MHz

    LPC_SCT->MATCH[0].L     = 10-1;                        // match 0 @ 10/2MHz = 5 usec (100 KHz PWM freq)
    LPC_SCT->MATCHREL[0].L  = 10-1;
    LPC_SCT->MATCH[1].L     = 5;                           // match 1 used for duty cycle (in 10 steps)
    LPC_SCT->MATCHREL[1].L  = 5;

    LPC_SCT->EVENT[0].STATE = 0xFFFF;                      // event 0 happens in all states
    LPC_SCT->EVENT[0].CTRL  = (1 << 0) | (1 << 12);        // match 1 condition only

//    LPC_SCT->OUT[0].SET     = (1 << 0);                  // event 0 will set SCT_OUT0
    LPC_SCT->OUT[0].CLR     = (1 << 0);                    // event 0 will clear SCT_OUT0
    LPC_SCT->OUTPUTDIRCTRL  = (0x1 << 0);                  // reverse output 0 set when down counting

    LPC_SCT->CTRL_L        &= ~(1 << 2);                   // unhalt it by clearing bit 2 of CTRL reg
}
